package io.dyte.webrtc

import DyteWebRTC.DyteRTCIceServer
import DyteWebRTC.RTCTlsCertPolicy

actual class IceServer internal constructor(val native: DyteRTCIceServer) {
  actual constructor(
    urls: List<String>,
    username: String,
    password: String,
    tlsCertPolicy: TlsCertPolicy,
    hostname: String,
    tlsAlpnProtocols: List<String>?,
    tlsEllipticCurves: List<String>?
  ) : this(
    DyteRTCIceServer(
      uRLStrings = urls,
      username = username,
      credential = password,
      tlsCertPolicy = tlsCertPolicy.asNative(),
      hostname = hostname,
      tlsAlpnProtocols = tlsAlpnProtocols,
      tlsEllipticCurves = tlsEllipticCurves
    )
  )

  actual override fun toString(): String = native.toString()
}

private fun TlsCertPolicy.asNative(): RTCTlsCertPolicy {
  return when (this) {
    TlsCertPolicy.TlsCertPolicySecure -> RTCTlsCertPolicy.RTCTlsCertPolicySecure
    TlsCertPolicy.TlsCertPolicyInsecureNoCheck -> {
      RTCTlsCertPolicy.RTCTlsCertPolicyInsecureNoCheck
    }
  }
}
