package io.dyte.webrtc

import DyteWebRTC.DyteRTCIceCandidate

actual class IceCandidate internal constructor(val native: DyteRTCIceCandidate) {
  actual constructor(
    sdpMid: String,
    sdpMLineIndex: Int,
    candidate: String
  ) : this(DyteRTCIceCandidate(candidate, sdpMLineIndex, sdpMid))

  actual val sdpMid: String = native.sdpMid!!
  actual val sdpMLineIndex: Int = native.sdpMLineIndex
  actual val candidate: String = native.sdp

  actual override fun toString(): String = candidate
}
