package io.dyte.webrtc

import android.util.Log
import org.webrtc.RtpParameters as AndroidRtpParameters

actual class RtpParameters(val native: AndroidRtpParameters) {
    actual var codecs: MutableList<RtpCodecParameters> = arrayListOf()
        get() = native.codecs.map { RtpCodecParameters(it) }.toMutableList()

    actual var encodings: List<RtpEncodingParameters> = emptyList()
        get() = native.encodings.map { RtpEncodingParameters(it) }

    actual var headerExtension: MutableList<HeaderExtension> = arrayListOf()
        get() = native.headerExtensions.map { HeaderExtension(it) }.toMutableList()

    actual val rtcp: RtcpParameters
        get() = RtcpParameters(native.rtcp)

    actual var transactionId: String = ""
        get() = native.transactionId

}

actual class RtpCodecParameters(val native: AndroidRtpParameters.Codec) {
    actual var payloadType: Int = 0
        get() = native.payloadType

    actual val mimeType: String?
        get() = try {
            val kindField = AndroidRtpParameters.Codec::class.java.getField("kind")
            kindField.isAccessible = true
            val kind = kindField.get(native) as? String
            if (kind != null && native.name != null) "$kind/${native.name}" else null
        } catch (e: Throwable) {
            Log.e("RtpCodecParameters", "Getting 'kind' field failed", e)
            null
        }

    actual val clockRate: Int?
        get() = native.clockRate

    actual var numChannels: Int? = null
        get() = native.numChannels

    actual val parameters: MutableMap<String, String>
        get() = native.parameters

    actual fun setRtpCodecParameters(
        payloadType: Int,
        mimeType: String?,
        clockRate: Int?,
        numChannels: Int?,
        parameters: MutableMap<String, String>
    ) {
        native.payloadType = payloadType
        //native.mimeType = mimeType
        native.clockRate = clockRate
        native.numChannels = numChannels
        native.parameters = parameters
    }
}

actual class RtpEncodingParameters(val native: AndroidRtpParameters.Encoding) {
    actual var rid: String? = null
        get() = native.rid

    actual var active: Boolean = false
        get() = native.active

    actual var bitratePriority: Double = 0.0
        get() = native.bitratePriority

    actual var networkPriority: Int = -1
        get() = native.networkPriority

    actual var maxBitrateBps: Int? = null
        get() = native.maxBitrateBps

    actual var minBitrateBps: Int? = null
        get() = native.minBitrateBps

    actual var maxFramerate: Int? = null
        get() = native.maxFramerate

    actual val numTemporalLayers: Int?
        get() = native.numTemporalLayers

    actual var scaleResolutionDownBy: Double? = null
        get() = native.scaleResolutionDownBy

    actual val ssrc: Long?
        get() = native.ssrc

    actual fun setRtpEncodingParameters(
        rid: String?,
        active: Boolean,
        bitratePriority: Double,
        networkPriority: Int,
        maxBitrateBps: Int?,
        minBitrateBps: Int?,
        maxFramerate: Int?,
        numTemporalLayers: Int?,
        scaleResolutionDownBy: Double?,
        ssrc: Long?
    ) {
        native.rid = rid
        native.active = active
        native.bitratePriority = bitratePriority
        native.networkPriority = networkPriority
        native.maxBitrateBps = maxBitrateBps
        native.minBitrateBps = minBitrateBps
        native.maxFramerate = maxFramerate
        native.numTemporalLayers = numTemporalLayers
        native.scaleResolutionDownBy = scaleResolutionDownBy
        native.ssrc = ssrc
    }
}

actual class HeaderExtension(val native: AndroidRtpParameters.HeaderExtension) {
    actual val uri: String
        get() = native.uri

    actual val id: Int
        get() = native.id

    actual var encrypted: Boolean = false
        get() = native.encrypted
}

actual class RtcpParameters(val native: AndroidRtpParameters.Rtcp) {
    actual var cname: String = ""
        get() = native.cname

    actual var reducedSize: Boolean? = null
        get() = native.reducedSize
}
