package io.dyte.webrtc.yuv

import io.github.zncmn.libyuv.Yuv

class YuvConvert {
  fun fromARGB(argb: ByteArray, yuv: ByteArray, width: Int, height: Int, format: YuvFormat) {
    if (format === YuvFormat.NV21) {
      Yuv.INSTANCE.abgrToNv21(argb, yuv, width, height)
    } else {
      throw UnsupportedOperationException("not supported format. $format")
    }
  }

  fun toARGB(yuv: ByteArray, argb: ByteArray, width: Int, height: Int, format: YuvFormat) {
    if (format === YuvFormat.NV21) {
      Yuv.INSTANCE.nv21ToAbgr(yuv, argb, width, height)
    } else {
      throw UnsupportedOperationException("not supported format. $format")
    }
  }
}
