package io.dyte.webrtc

import android.graphics.Bitmap
import java.nio.ByteBuffer

class DyteVideoFrame
internal constructor(
  val byteArray: ByteArray,
) {
  fun toBitmap(): Bitmap {
    val bitmap = Bitmap.createBitmap(FRAME_HEIGHT, FRAME_WIDTH, Bitmap.Config.ARGB_8888)
    bitmap.copyPixelsFromBuffer(toByteBuffer())
    return bitmap
  }

  fun toByteBuffer(): ByteBuffer {
    return ByteBuffer.wrap(byteArray)
  }

  companion object {
    var FRAME_HEIGHT = DEFAULT_VIDEO_HEIGHT
    var FRAME_WIDTH = DEFAULT_VIDEO_WIDTH

    fun fromBitmap(bitmap: Bitmap): DyteVideoFrame {
      val bBuffer = ByteBuffer.allocate(bitmap.byteCount)
      bitmap.copyPixelsToBuffer(bBuffer)
      return fromByteBuffer(bBuffer)
    }

    fun fromByteBuffer(byteBuffer: ByteBuffer): DyteVideoFrame {
      return DyteVideoFrame(byteBuffer.array())
    }

    fun fromByteArray(byteArray: ByteArray): DyteVideoFrame {
      return DyteVideoFrame(byteArray)
    }
  }
}
