package io.dyte.sockrates.client

import message.v1.SocketMessage

interface SockratesWSListener {

  fun onOpen(client: Sockrates) {}

  fun onClose(client: Sockrates, code: Int, reason: String) {}

  fun onMessage(client: Sockrates, message: WebSocketMessage) {}

  fun onMessage(client: Sockrates, message: SocketMessage) {}

  fun onConnectionStateChanged(client: Sockrates, newState: WebSocketConnectionState) {}

  fun onError(client: Sockrates, exception: Exception) {}
}

sealed class WebSocketMessage {
  data class Text(val message: String) : WebSocketMessage()

  data class Binary(val message: ByteArray) : WebSocketMessage() {
    override fun equals(other: Any?): Boolean {
      if (this === other) return true
      if (other == null || this::class != other::class) return false

      other as Binary

      if (!message.contentEquals(other.message)) return false

      return true
    }

    override fun hashCode(): Int {
      return message.contentHashCode()
    }
  }
}
