package io.dyte.sockrates.client

internal enum class WebSocketReadyState {
  CONNECTING,
  OPEN,
  CLOSING,
  CLOSED
}

sealed class WebSocketConnectionState {

  object Connected : WebSocketConnectionState()

  data class Disconnected(
    val code: Int,
    val reason: String
  ) : WebSocketConnectionState()

  // Only for logging purposes, can be made internal
  data class AttemptingReconnect(val attemptNumber: Int) : WebSocketConnectionState()

  object Reconnecting : WebSocketConnectionState()

  object Reconnected : WebSocketConnectionState()

  // Only for logging purposes, can be made internal
  data class ReconnectAttemptFailed(val attemptNumber: Int) : WebSocketConnectionState()

  object ReconnectFailed : WebSocketConnectionState()

  object Error : WebSocketConnectionState()
}
