package io.dyte.sockrates.client

import message.v1.SocketMessage
import kotlin.DeprecationLevel.HIDDEN

interface SockratesWSListener {

  fun onOpen(client: Sockrates) {}

  @Deprecated(
    level = HIDDEN,
    message = "Removing in favour of a single onMessage callback method",
    replaceWith = ReplaceWith("SockratesWSListener.onMessage(client: Sockrates, message: WebSocketMessage)")
  )
  fun onMessage(client: Sockrates, message: String) {
  }

  @Deprecated(
    level = HIDDEN,
    message = "Removing in favour of a single onMessage callback method",
    replaceWith = ReplaceWith("SockratesWSListener.onMessage(client: Sockrates, message: WebSocketMessage)")
  )
  fun onMessage(client: Sockrates, message: ByteArray) {
  }

  fun onMessage(client: Sockrates, message: WebSocketMessage) {}

  fun onMessage(client: Sockrates, message: SocketMessage) {}

  fun onConnectionStateChanged(client: Sockrates, newState: WebSocketConnectionState) {}

  fun onClosed(client: Sockrates, code: Int, reason: String) {}

  fun onFailure(client: Sockrates, exception: Exception, reason: String) {}
}

sealed class WebSocketMessage {
  data class Text(val message: String) : WebSocketMessage()
  data class Binary(val message: ByteArray) : WebSocketMessage() {
    override fun equals(other: Any?): Boolean {
      if (this === other) return true
      if (other == null || this::class != other::class) return false

      other as Binary

      if (!message.contentEquals(other.message)) return false

      return true
    }

    override fun hashCode(): Int {
      return message.contentHashCode()
    }
  }
}