package io.dyte.core.socket.events.payloadmodel.outbound

import io.dyte.core.socket.events.OutboundMeetingEventType
import io.dyte.core.socket.events.payloadmodel.BasePayloadModel
import io.dyte.core.socket.events.payloadmodel.inbound.WebSocketMeetingPeerUser
import kotlinx.serialization.ExperimentalSerializationApi
import kotlinx.serialization.SerialName
import kotlinx.serialization.Serializable
import kotlinx.serialization.json.JsonNames

/**
 * response for [OutboundMeetingEventType.GET_ROOM_STATE]
 */
@OptIn(ExperimentalSerializationApi::class)
@Serializable
data class WebSocketRoomStateModel(
  @JsonNames("roomState")
  val roomState: RoomState? = null
) : BasePayloadModel()

@OptIn(ExperimentalSerializationApi::class)
@Serializable
data class RoomState(
  @JsonNames("displayTitle")
  val displayTitle: String? = null,

  @JsonNames("peers")
  val peers: List<WebSocketMeetingPeerUser>? = null,

  @JsonNames("lockedMode")
  val lockedMode: Boolean? = null,

  @JsonNames("roomUUID")
  val roomUUID: String? = null,

  @JsonNames("config")
  val config: RoomStateConfig? = null,

  @JsonNames("plugins")
  val plugins: List<RoomStatePlugin>? = null,

  @JsonNames("roomName")
  val roomName: String? = null
)

@OptIn(ExperimentalSerializationApi::class)
@Serializable
data class RoomStateConfig(
  @JsonNames("joinRestrictions")
  val joinRestrictions: List<String>? = null,

  @JsonNames("access")
  val access: RoomStateAccess? = null
)

@OptIn(ExperimentalSerializationApi::class)
@Serializable
data class RoomStateAccess(
  @JsonNames("mic")
  val mic: String? = null,

  @JsonNames("webcam")
  val webcam: String? = null,

  @JsonNames("screenShare")
  val screenShare: String? = null,

  @JsonNames("plugins")
  val plugins: String? = null
)

@Serializable
data class RoomStatePlugin(
  val id: String,
  val staggered: Boolean,
  val enabledBy: String,
  val stores: List<String>,
  @SerialName("ACLAccessRemovedUsers") val aclAccessRemovedUsers: List<String>,
  @SerialName("ACLAccessGrantedUsers") val aclAccessGrantedUsers: List<String>,
  @SerialName("ACLType") val aclType: String

)