package io.dyte.core.socket.events.payloadmodel.outbound

import io.dyte.core.socket.events.OutboundMeetingEventType
import io.dyte.core.socket.events.payloadmodel.BasePayloadModel
import io.dyte.core.socket.events.payloadmodel.inbound.WebSocketMeetingPeerUser
import kotlinx.serialization.ExperimentalSerializationApi
import kotlinx.serialization.Serializable
import kotlinx.serialization.json.JsonNames

/**
 * response for [OutboundMeetingEventType.JOIN_ROOM]
 */
@OptIn(ExperimentalSerializationApi::class)
@Serializable
data class WebSocketJoinRoomModel(
  @JsonNames("waitlisted")
  val waitlisted: Boolean? = null,

  @JsonNames("peers")
  val peers: List<WebSocketMeetingPeerUser>? = null,

  @JsonNames("waitlistedPeers")
  val waitlistedPeers: List<WebSocketMeetingPeerUser>? = null,

  val startedAt: String? = null,
  val isHost: Boolean,
) : BasePayloadModel()