package io.dyte.core.socket.events.payloadmodel.outbound

import io.dyte.core.socket.events.OutboundMeetingEventType
import io.dyte.core.socket.events.payloadmodel.BasePayloadModel
import kotlinx.serialization.ExperimentalSerializationApi
import kotlinx.serialization.Serializable
import kotlinx.serialization.json.JsonNames

/**
 * response for [OutboundMeetingEventType.GET_ROUTER_RTP_CAPABILITIES]
 */
@OptIn(ExperimentalSerializationApi::class)
@Serializable
data class RouterCapabilitiesModel(
  @JsonNames("codecs")
  val codecs: List<Codec>? = null,

  @JsonNames("headerExtensions")
  val headerExtensions: List<HeaderExtension>? = null
) : BasePayloadModel()

@OptIn(ExperimentalSerializationApi::class)
@Serializable
data class Codec(
  @JsonNames("kind")
  var kind: String? = null,

  @JsonNames("mimeType")
  var mimeType: String? = null,

  @JsonNames("payloadType")
  var payloadType: Int? = null,

  @JsonNames("clockRate")
  var clockRate: Int? = null,

  @JsonNames("channels")
  var channels: Int? = null,

  @JsonNames("rtcpFeedback")
  var rtcpFeedback: List<CodecRtcpFeedback>? = null,

  @JsonNames("parameters")
  var parameters: CodecParameters? = null,

  @JsonNames("preferredPayloadType")
  var preferredPayloadType: Int? = null
)

@OptIn(ExperimentalSerializationApi::class)
@Serializable
data class HeaderExtension(
  @JsonNames("kind")
  var kind: String? = null,

  @JsonNames("uri")
  var uri: String? = null,

  @JsonNames("preferredId")
  var preferredId: Int? = null,

  @JsonNames("id")
  var id: Int? = null,

  @JsonNames("preferredEncrypt")
  var preferredEncrypt: Boolean? = null,

  @JsonNames("encrypt")
  var encrypt: Boolean? = null,

  @JsonNames("direction")
  var direction: String? = null
)

@OptIn(ExperimentalSerializationApi::class)
@Serializable
data class CodecParameters(
  @JsonNames("x-google-start-bitrate")
  var xGoogleStartBitrate: Int? = null,

  @JsonNames("apt")
  var apt: Int? = null,

  @JsonNames("profile-id")
  var profileId: Int? = null,

  @JsonNames("packetization-mode")
  var packetizationMode: Int? = null,

  @JsonNames("level-asymmetry-allowed")
  var levelAsymmetryAllowed: Int? = null,

  @JsonNames("profile-level-id")
  var profileLevelId: String? = null
)

@OptIn(ExperimentalSerializationApi::class)
@Serializable
data class CodecRtcpFeedback(
  @JsonNames("type")
  var type: String? = null,

  @JsonNames("parameter")
  var parameter: String? = null
)