package io.dyte.core.socket.events.payloadmodel.outbound

import io.dyte.core.socket.events.OutboundMeetingEventType
import io.dyte.core.socket.events.payloadmodel.inbound.Device
import kotlinx.serialization.ExperimentalSerializationApi
import kotlinx.serialization.Serializable
import kotlinx.serialization.json.JsonNames

/**
 * request for [OutboundMeetingEventType.JOIN_ROOM]
 */
@OptIn(ExperimentalSerializationApi::class)
@Serializable
data class JoinRoomPayloadRequestModel(
  @JsonNames("device")
  var device: Device? = null,

  @JsonNames("displayName")
  var displayName: String? = null,

  @JsonNames("rtpCapabilities")
  var rtpCapabilities: RouterCapabilitiesModel? = null,

  @JsonNames("isLegacy")
  var isLegacy: Boolean = false,

  @JsonNames("audioMuted")
  var audioMuted: Boolean = false
)