package io.dyte.core.network.models

import kotlinx.serialization.ExperimentalSerializationApi
import kotlinx.serialization.Serializable
import kotlinx.serialization.json.JsonNames

@OptIn(ExperimentalSerializationApi::class)
@Serializable
data class UserData(
  @JsonNames("id")
  val id: String? = null,

  @JsonNames("name")
  val name: String? = null,

  @JsonNames("email")
  val email: String? = null,

  @JsonNames("picture")
  val picture: String? = null,

  @JsonNames("loggedIn")
  val loggedIn: Boolean? = null,

  @JsonNames("clientSpecificId")
  val clientSpecificId: String? = null,

  @JsonNames("organizationId")
  val organizationId: String? = null
)

@OptIn(ExperimentalSerializationApi::class)
@Serializable
data class UserDataWrapper(
  @JsonNames("user")
  val user: UserData
)