package io.dyte.core.network

import io.dyte.core.network.models.PresignedUrlRequest
import io.dyte.core.network.models.PresignedUrlResponse
import io.ktor.client.call.body
import io.ktor.client.request.post
import io.ktor.client.request.setBody
import io.ktor.http.ContentType
import io.ktor.http.contentType

internal class PresignedUrlApiService : BaseApiService() {
  suspend fun getPresignedUrl(filename: String?, meetingRoomName: String): PresignedUrlResponse? {
    return try {
      val response = client.post("https://api.staging.dyte.in/v1/meetings/genPreSignedUploadUrl") {
        contentType(ContentType.Application.Json)
        setBody(PresignedUrlRequest(meetingRoomName, filename))
      }
      response.body()
    } catch (e: Exception) {
      e.printStackTrace()
      null
    }
  }
}