package io.dyte.core.models

data class DytePollMessage(
  val id: String,
  val quesion: String,
  val anonymous: Boolean,
  val hideVotes: Boolean,
  val createdBy: String,
  val options: List<DytePollOption>
){
  fun toMap() : Map<String, Any?> {
    val map = HashMap<String, Any?>()
    map["id"] = id
    map["question"] = quesion
    map["anonymous"] = anonymous
    map["hideVotes"] = hideVotes
    map["createdBy"] = createdBy
    map["options"] = options.map { it.toMap() }
    return map
  }
}

data class DytePollOption(
  val text: String,
  val votes: List<DytePollVote>,
  val count: Number
) {
  fun toMap() : Map<String, Any?> {
    val map = HashMap<String, Any?>()
    map["text"] = text
    map["votes"] = votes.map { it.toMap() }
    map["count"] = count
    return map
  }

}

data class DytePollVote(
  val id: String,
  val name: String,
) {
  fun toMap() : Map<String, Any?> {
    val map = HashMap<String, Any?>()
    map["id"] = id
    map["name"] = name
    return map
  }
}