package io.dyte.core.models

import io.dyte.core.controllers.IControllerContainer
import kotlinx.coroutines.DelicateCoroutinesApi
import kotlinx.serialization.ExperimentalSerializationApi

@OptIn(ExperimentalSerializationApi::class, DelicateCoroutinesApi::class)
class DyteParticipant(
  override val id: String,
  override val userId: String,
  override val name: String,
  override val picture: String?,
  override val isHost: Boolean,
  override val clientSpecificId: String,
  override val flags: ParticipantFlags,
  override var audioEnabled: Boolean,
  override var videoEnabled: Boolean,
  controllerContainer: IControllerContainer
) : DyteMeetingParticipant(
  id, userId, name, picture,
  isHost, clientSpecificId, flags, audioEnabled,
  videoEnabled, controllerContainer
)