package io.dyte.core.models

data class DyteMeetingInfo(
  val orgId: String,
  val roomName: String,
  val authToken: String,
  val enableAudio: Boolean = true,
  val enableVideo: Boolean = true,
  val baseUrl: String = "https://api.cluster.dyte.in",
  val displayName: String = "hello from android",
) {
  companion object {
    fun fromMap(map: Map<String, Any?>) : DyteMeetingInfo {
      return DyteMeetingInfo(
        orgId = map["orgId"] as String,
        roomName = map["roomName"] as String,
        authToken = map["authToken"] as String,
        enableAudio = map["enableAudio"] as Boolean,
        enableVideo = map["enableVideo"] as Boolean,
        baseUrl = map["baseUrl"] as String,
        displayName = map["displayName"] as String
      )
    }
  }
}