package io.dyte.core.controllers

import io.dyte.core.network.models.UserPresetModel
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.runBlocking

internal class PresetController(controllerContainer: IControllerContainer) :
  BaseController(controllerContainer), IPresetController {
  override lateinit var permission: UserPresetModel

  override fun init() {
    permission = runBlocking(Dispatchers.Default) {
      requireNotNull(controllerContainer.apiClient.getUserPreset().data?.preset)
    }
  }

  override fun canSendPublicTextMessages(): Boolean {
    return permission.permissions?.chat?.chatPublicProps?.canSend ?: false
  }

  override fun canPublishVideo(): Boolean {
    return permission.permissions?.produce?.video?.allow ?: false
  }

  override fun canPublishAudio(): Boolean {
    return permission.permissions?.produce?.audio ?: false
  }

  override fun canCreatePoll(): Boolean {
    return permission.permissions?.polls?.canCreate ?: false
  }

  override fun canViewPoll(): Boolean {
    return permission.permissions?.polls?.canView ?: false
  }

  override fun canVoteOnPoll(): Boolean {
    return permission.permissions?.polls?.canVote ?: false
  }

  override fun closePlugins(): Boolean {
    return permission.permissions?.plugins?.canClose ?: false
  }

  override fun canStartPlugins(): Boolean {
    return permission.permissions?.plugins?.canStart ?: false
  }

  override fun getMaxVideoCount(): Int {
    return permission.theme?.grid?.multi?.maxVideoCount ?: 6
  }

  override fun canRecord(): Boolean {
    return permission.permissions?.canRecord ?: false
  }

  override fun canSendChatText(): Boolean {
    return permission.permissions?.chat?.chatPublicProps?.canSend ?: false
  }

  override fun canSendChatFile(): Boolean {
    return permission.permissions?.chat?.chatPublicProps?.files ?: false
  }
}

interface IPresetController {
  val permission: UserPresetModel
  fun canSendPublicTextMessages(): Boolean

  fun canPublishVideo(): Boolean
  fun canPublishAudio(): Boolean

  fun canCreatePoll(): Boolean
  fun canViewPoll(): Boolean
  fun canVoteOnPoll(): Boolean

  fun canSendChatText(): Boolean
  fun canSendChatFile(): Boolean

  fun closePlugins(): Boolean
  fun canStartPlugins(): Boolean

  fun getMaxVideoCount(): Int

  fun canRecord(): Boolean
}