package io.dyte.core

import io.dyte.core.platform.IDytePlatformUtils

object Utils {
  fun getInitialsFromName(name: String): String {
    val trimmedName = name.trim()

    if (trimmedName.isBlank()) {
      return "NN"
    }

    if (trimmedName.length < 2) {
      return trimmedName.first().toString().uppercase()
    }

    val subNames = trimmedName.split(" ")
    return if (subNames.size >= 2) {
      "${subNames.first().first()}${subNames.last().first()}".uppercase()
    } else {
      subNames.first().substring(0, 2).uppercase()
    }
  }

  /**
   * getDeviceInfo = () => ({
  isMobile: this.isMobile(),
  browserName: this._bowser.getBrowserName(),
  osName: this._bowser.getOSName(),
  browserVersion: this._bowser.getBrowserVersion(),
  osVersionName: this._bowser.getOSVersion(),
  engineName: this._bowser.getEngineName(),
  });
   */
  fun getDeviceInfo(platformUtils: IDytePlatformUtils) : Map<String, String>{
    return hashMapOf("isMobile" to "true", "osName" to platformUtils.getOsName(), "osVersionName" to platformUtils.getOsVersion(), "deviceInfo" to platformUtils.getDeviceInfo())
  }
}