package io.dyte.core.socket.events.payloadmodel.inbound

import io.dyte.core.socket.events.InboundMeetingEventType
import io.dyte.core.socket.events.payloadmodel.BasePayloadModel
import kotlinx.serialization.ExperimentalSerializationApi
import kotlinx.serialization.Serializable
import kotlinx.serialization.json.JsonNames

/**
 * response for event [InboundMeetingEventType.WEB_SOCKET_CONNECT_TRANSPORT]
 */
@Serializable
@OptIn(ExperimentalSerializationApi::class)
data class WebSocketPollsModel(
  @JsonNames("polls")
  val polls: Map<String, WebSocketPoll>? = null
) : BasePayloadModel()

@OptIn(ExperimentalSerializationApi::class)
@Serializable
data class WebSocketPollModel(
  @JsonNames("poll")
  val poll: WebSocketPoll
) : BasePayloadModel()

@OptIn(ExperimentalSerializationApi::class)
@Serializable
data class WebSocketPoll(
  val id: String,
  val options: List<WebSocketPollOption>,
  val question: String,
  val anonymous: Boolean,
  val hideVotes: Boolean,
  val createdBy: String
)

@OptIn(ExperimentalSerializationApi::class)
@Serializable
data class WebSocketPollOption(
  val text: String,
  val votes: List<WebSocketPollVote>,
  val count: Int
)

@OptIn(ExperimentalSerializationApi::class)
@Serializable
data class WebSocketPollVote(
  val id: String,
  val name: String
)
