package io.dyte.core.socket

@Suppress("NO_ACTUAL_FOR_EXPECT")
expect sealed class SocketEvent<T> {
  object Connect : SocketEvent<Unit>
  object Connecting : SocketEvent<Unit>
  object Disconnect : SocketEvent<Unit>
  object Error : SocketEvent<Any>
  object Message : SocketEvent<Any>
  object Reconnect : SocketEvent<Unit>
  object ReconnectAttempt : SocketEvent<Int>
  object Ping : SocketEvent<Unit>
  object Pong : SocketEvent<Unit>
}

const val EVENT_CONNECT = "connect"
const val EVENT_CONNECTING = "connecting"
const val EVENT_DISCONNECT = "disconnect"
const val EVENT_ERROR = "error"
const val EVENT_MESSAGE = "message"
const val EVENT_CONNECT_ERROR = "connect_error"
const val EVENT_RECONNECT = "reconnect"
const val EVENT_RECONNECT_ERROR = "reconnect_error"
const val EVENT_RECONNECT_ATTEMPT = "reconnect_attempt"
const val EVENT_RECONNECT_FAILED = "reconnect_failed"
const val EVENT_PING = "ping"
const val EVENT_PONG = "pong"
