package io.dyte.core.models

data class DyteVideoDevice(
  val id: String,
  val type: VideoDeviceType,
) {
  fun toMap() : Map<String, Any?> {
    val map = HashMap<String, Any?>()
    map["id"] = id
    map["type"] = type.toMap()
    return map
  }
}

enum class VideoDeviceType(val displayName: String) {
  FRONT("Front camera"),
  REAR( "Rear camera"),
  EXTERNAL( "External");
  fun toMap() : Map<String, Any?> {
    val map = HashMap<String, Any?>()
    map["displayName"] = displayName
    return map
  }
}
