package io.dyte.core.models

import io.dyte.core.controllers.IControllerContainer

class DyteMeta(private val controllerContainer: IControllerContainer) {
  val roomName: String
    get() = controllerContainer.metaController.getRoomName()

  val meetingTitle: String
    get() = controllerContainer.metaController.getMeetingTitle()

  val meetingStartedTimestamp: String
    get() = controllerContainer.metaController.getMeetingStatedTimestamp()

  val roomType: String
    get() = controllerContainer.metaController.getRoomType()

  fun toMap() : Map<String, Any?> {
    val map = HashMap<String, Any?>()
    map["roomName"] = roomName
    map["meetingTitle"] = meetingTitle
    map["meetingStartedTimestamp"] = meetingStartedTimestamp
    map["roomType"] = roomType
    return map
  }
}