package io.dyte.core.models

import io.dyte.core.controllers.IControllerContainer

// TODO : add pin/unpin support
// TODO: add pinned message type.
// TODO : getMessagesByUser
// TODO : getMessageByType
class DyteChat(private val controllerContainer: IControllerContainer) {
  val messages = arrayListOf<DyteChatMessage>()

  internal fun addMessages(messages: List<DyteChatMessage>) {
    this.messages.clear()
    this.messages.addAll(messages)
  }

  internal fun addMessage(message: DyteChatMessage) {
    this.messages.add(message)
  }

  fun toMap() : List<Map<String, Any?>> {
    return messages.map { encodeDyteChatMessage(it) }
  }

  /**
   * Sends a string type chat message in the given room
   *
   * @param message
   */
  @Throws(UnsupportedOperationException::class)
  fun sendTextMessage(message: String) {
    controllerContainer.chatController.sendMessage(message)
  }

  /**
   * Send file message
   *
   * @param filePath Location of file on device storage
   * @param fileName Name of the file, displayed on chat screen
   */
  fun sendFileMessage(filePath: String, fileName: String) {
    controllerContainer.chatController.sendFileMessage(fileName, filePath)
  }

  /**
   * Send chat image message
   *
   * @param filePath Location of image file on device storage
   * @param fileName Name of the image file, displayed on chat screen
   */
  @Suppress("UNUSED_PARAMETER")
  fun sendImageMessage(filePath: String, fileName: String) {
    controllerContainer.chatController.sendFileMessage(fileName, filePath)
  }
}