package io.dyte.core.socket.events.payloadmodel.outbound

import io.dyte.core.socket.events.OutboundMeetingEventType
import io.dyte.core.socket.events.payloadmodel.BasePayloadModel
import kotlinx.serialization.ExperimentalSerializationApi
import kotlinx.serialization.Serializable
import kotlinx.serialization.json.JsonNames

/**
 * response for [OutboundMeetingEventType.CREATE_WEB_RTC_TRANSPORT]
 */
@OptIn(ExperimentalSerializationApi::class)
@Serializable
data class WebRtcCreateTransportModel(
  @JsonNames("id")
  var id: String? = null,

  @JsonNames("iceParameters")
  var iceParameters: IceParameters? = null,

  @JsonNames("iceCandidates")
  var iceCandidates: List<IceCandidate>? = null,

  @JsonNames("dtlsParameters")
  var dtlsParameters: DtlsParameters? = null,

  @JsonNames("producing")
  var producing: Boolean? = null
) : BasePayloadModel()

@OptIn(ExperimentalSerializationApi::class)
@Serializable
data class DtlsParameters(
  @JsonNames("fingerprints")
  var fingerprints: List<Fingerprint>? = null,

  @JsonNames("role")
  var role: String? = null
)

@OptIn(ExperimentalSerializationApi::class)
@Serializable
data class Fingerprint(
  @JsonNames("algorithm")
  var algorithm: String? = null,

  @JsonNames("value")
  var value: String? = null
)

@OptIn(ExperimentalSerializationApi::class)
@Serializable
data class IceCandidate(
  @JsonNames("foundation")
  var foundation: String? = null,

  @JsonNames("ip")
  var ip: String? = null,

  @JsonNames("port")
  var port: Int? = null,

  @JsonNames("priority")
  var priority: Int? = null,

  @JsonNames("protocol")
  var protocol: String? = null,

  @JsonNames("type")
  var type: String? = null,

  @JsonNames("tcpType")
  var tcpType: String? = null
)

@OptIn(ExperimentalSerializationApi::class)
@Serializable
data class IceParameters(
  @JsonNames("iceLite")
  var iceLite: Boolean? = null,

  @JsonNames("password")
  var password: String? = null,

  @JsonNames("usernameFragment")
  var usernameFragment: String? = null
)
