package io.dyte.core.socket.events.payloadmodel.inbound

import io.dyte.core.socket.events.InboundMeetingEventType
import io.dyte.core.socket.events.payloadmodel.BasePayloadModel
import kotlinx.serialization.ExperimentalSerializationApi
import kotlinx.serialization.Serializable
import kotlinx.serialization.json.JsonNames

/**
 * response for event [InboundMeetingEventType.WEB_SOCKET_CONNECT_TRANSPORT]
 */

@Serializable
data class WebSocketChatMessagesModel(
  @JsonNames("messages")
  val messages: List<WebSocketChatMessage>? = null
) : BasePayloadModel()

@Serializable
data class WebSocketChatMessage(
  val message: String? = null,
  val userId: String,
  val displayName: String,
  val type: Int,
  val link: String? = null,
  val time: Long? = null
) : BasePayloadModel()
