package io.dyte.core.platform

import io.dyte.core.controllers.IControllerContainer
import io.dyte.core.socket.events.payloadmodel.inbound.WebSocketConsumerClosedModel
import io.dyte.core.socket.events.payloadmodel.inbound.WebSocketConsumerModel
import io.dyte.core.socket.events.payloadmodel.outbound.WebRtcCreateTransportModel
import io.dyte.core.network.models.IceServerData

interface IDyteMediaSoupUtils {
  fun init(controllerContainer: IControllerContainer)

  fun loadRouterRtpCapabilities(routerRtpCapabilitiesString: String)
  fun createWebRtcTransportRecv(
    model: WebRtcCreateTransportModel,
    iceServers: List<IceServerData>
  )
  fun createWebRtcTransportProd(
    model: WebRtcCreateTransportModel,
    iceServers: List<IceServerData>
  )
  fun connectTransport(id: String, producing: Boolean, onDone: () -> Unit)

  fun handleNewConsumer(
    webSocketConsumerModel: WebSocketConsumerModel,
    onDone: () -> Unit
  )
  fun handleCloseConsumer(webSocketConsumerModel: WebSocketConsumerClosedModel)
  fun resumeConsumer(id: String)

  fun muteSelfAudio(): Boolean
  fun unmuteSelfAudio(): Boolean

  fun muteSelfVideo(): Boolean
  fun unmuteSelfVideo(): Boolean

  fun getSelfTrack(): Pair<Any?, Any?>

  fun leaveCall()

  fun switchCamera()

  fun onCameraStreamKilled()
}