package io.dyte.core.models

data class DyteVideoDevice(
  val id: String,
  val type: VideoDeviceType,
) {
  companion object default {
    fun fromMap(map: Map<String, Any>): DyteVideoDevice {
      val id = map.get("id") as String
      val typeMap = map.get("type") as Map<String, Any>
      val type = VideoDeviceType.fromMap(typeMap)
      return DyteVideoDevice(id, type)
    }
  }

  fun toMap() : Map<String, Any?> {
    val map = HashMap<String, Any?>()
    map["id"] = id
    map["type"] = type.toMap()
    return map
  }
}

enum class VideoDeviceType(val displayName: String) {
  FRONT("Front camera"),
  REAR( "Rear camera"),
  EXTERNAL( "External");

  companion object default {
    fun fromMap(map: Map<String, Any>) : VideoDeviceType {
      return when(map["displayName"]){
        "Front camera" -> FRONT
        "Rear camera" -> REAR
        else -> EXTERNAL
      }
    }
  }

  fun toMap() : Map<String, Any?> {
    val map = HashMap<String, Any?>()
    map["displayName"] = displayName
    return map
  }
}
