package io.dyte.core.socket

actual sealed class SocketEvent<T> : Mapper<T> {


  actual object Connect : SocketEvent<Unit>(), Mapper<Unit> by UnitMapper() {
    override val socketIoEvents: List<String> = listOf(EVENT_CONNECT)
  }

  actual object Connecting : SocketEvent<Unit>(), Mapper<Unit> by UnitMapper() {
    override val socketIoEvents: List<String> = listOf(EVENT_CONNECTING)
  }

  actual object Disconnect : SocketEvent<Unit>(), Mapper<Unit> by UnitMapper() {
    override val socketIoEvents: List<String> = listOf(EVENT_DISCONNECT)
  }

  actual object Error : SocketEvent<Any>() {
    override val socketIoEvents: List<String> = listOf(
      EVENT_ERROR,
      EVENT_CONNECT_ERROR,
      EVENT_RECONNECT_ERROR,
      EVENT_RECONNECT_FAILED
    )

    override fun mapper(array: Array<out Any>): Any {
      return array[0]
    }
  }

  actual object Message : SocketEvent<Any>() {
    override val socketIoEvents: List<String> = listOf(EVENT_MESSAGE)
    override fun mapper(array: Array<out Any>): Any {
      return array
    }
  }

  actual object Reconnect : SocketEvent<Unit>(), Mapper<Unit> by UnitMapper() {
    override val socketIoEvents: List<String> = listOf(EVENT_RECONNECT)
  }

  actual object ReconnectAttempt : SocketEvent<Int>() {
    override val socketIoEvents: List<String> = listOf(EVENT_RECONNECT_ATTEMPT)
    override fun mapper(array: Array<out Any>): Int {
      return array[0] as Int
    }
  }

  actual object Ping : SocketEvent<Unit>(), Mapper<Unit> by UnitMapper() {
    override val socketIoEvents: List<String> = listOf(EVENT_PING)
  }

  actual object Pong : SocketEvent<Unit>(), Mapper<Unit> by UnitMapper() {
    override val socketIoEvents: List<String> = listOf(EVENT_PONG)
  }

  abstract val socketIoEvents: List<String>

  private class UnitMapper : Mapper<Unit> {
    override fun mapper(array: Array<out Any>) = Unit
  }
}