package io.dyte.core.platform

import android.app.Activity
import android.util.Base64
import io.dyte.core.controllers.IControllerContainer
import org.json.JSONObject
import java.io.UnsupportedEncodingException

/**
 * Dyte android platform provider
 *
 * creates and maintains platform specific code required by core sdk
 *
 * @constructor Create empty Dyte android platform provider
 */
internal class DyteAndroidPlatformProvider(activity: Activity) : IDytePlatformUtilsProvider {
  private lateinit var _controllerContainer: IControllerContainer

  private var platformUtils: DyteAndroidPlatform? = null
  private var loggerUtils: DyteAndroidLogger? = null
  private var mediaUtils: DyteAndroidMedia? = null
  private var peerConnectionUtils: DyteAndroidPeerConnection? = null
  private var mediaSoupUtils: DyteAndroidMediaSoup? = null
  private var videoUtils: DyteAndroidVideoUtils? = null

  init {
    peerConnectionUtils = DyteAndroidPeerConnection(this)
    platformUtils = DyteAndroidPlatform(activity, this)
  }

  override fun init(controllerContainer: IControllerContainer) {
    this._controllerContainer = controllerContainer
    loggerUtils = DyteAndroidLogger()
    mediaUtils = DyteAndroidMedia(this)
    mediaSoupUtils = DyteAndroidMediaSoup()
    videoUtils = DyteAndroidVideoUtils(this)
  }

  override fun getPlatformUtils(): IDytePlatformUtils {
    return requireNotNull(platformUtils)
  }

  override fun getLogger(): IDyteLoggerUtils {
    return requireNotNull(loggerUtils)
  }

  override fun getMediaUtils(): IDyteMediaUtils {
    return requireNotNull(mediaUtils)
  }

  override fun getPeerConnectionUtils(): IDytePeerConnectionUtils {
    return requireNotNull(peerConnectionUtils)
  }

  override fun getMediaSoupUtils(): IDyteMediaSoupUtils {
    return requireNotNull(mediaSoupUtils)
  }

  override fun getControllerContainer(): IControllerContainer {
    return _controllerContainer
  }

  override fun createWebView(): IDyteWebView {
    return DyteAndroidWebView(this)
  }

  override fun getVideoUtils(): IDyteVideoUtils {
    return requireNotNull(videoUtils)
  }
}