package io.dyte.core

import android.content.Context
import android.util.AttributeSet
import android.widget.LinearLayout
import androidx.core.view.doOnLayout
import io.dyte.core.controllers.IControllerContainer
import io.dyte.core.models.DyteMeetingParticipant
import org.webrtc.EglBase
import org.webrtc.RendererCommon.RendererEvents
import org.webrtc.RendererCommon.ScalingType.SCALE_ASPECT_FILL
import org.webrtc.RendererCommon.ScalingType.SCALE_ASPECT_FIT
import org.webrtc.SurfaceViewRenderer
import org.webrtc.VideoTrack

class VideoView : LinearLayout {
  private var participant: DyteMeetingParticipant? = null
  private var videoRenderer: SurfaceViewRenderer? = null
  private var controllerContainer: IControllerContainer? = null

  constructor(context: Context) : super(context) {
    init(context)
  }

  constructor(context: Context, attrs: AttributeSet?) : super(context, attrs) {
    init(context)
  }

  constructor(context: Context, attrs: AttributeSet?, defStyleAttr: Int) : super(
    context,
    attrs,
    defStyleAttr
  ) {
    init(context)
  }

  private fun init(context: Context) {
    inflate(context, R.layout.view_video, this)
    videoRenderer = findViewById(R.id.video_renderer)
  }

  internal fun setup(
    controllerContainer: IControllerContainer,
    dyteParticipant: DyteMeetingParticipant
  ) {
    this.participant = dyteParticipant
    this.controllerContainer = controllerContainer
    videoRenderer?.setScalingType(SCALE_ASPECT_FIT)
    videoRenderer?.init(
      controllerContainer.platformUtilsProvider.getPeerConnectionUtils().getEglContext() as EglBase.Context, null)
  }

  fun renderVideo() {
    var track: VideoTrack? = null
    if (participant?.videoEnabled == true && participant?.videoTrack is VideoTrack) {
      track = participant?.videoTrack as VideoTrack
    }

    if (track != null) {
      videoRenderer?.visibility = VISIBLE
      track.removeSink(videoRenderer)
      track.addSink(videoRenderer)
    } else {
      videoRenderer?.visibility = GONE
    }
  }

  fun renderScreenShare() {
    var track: VideoTrack? = null
    if (participant?._screenShareTrack != null) {
      track = participant?.screenShareTrack as VideoTrack
    }

    if (track != null) {
      videoRenderer?.visibility = VISIBLE
      track.removeSink(videoRenderer)
      track.addSink(videoRenderer)
    } else {
      videoRenderer?.visibility = GONE
    }
  }

  fun release() {
    videoRenderer?.clearImage()
    videoRenderer?.release()
  }
}