package io.dyte.core.platform

import io.dyte.core.controllers.IControllerContainer
import io.dyte.core.controllers.PermissionType

interface IDytePlatformUtils {
  fun getCurrentTime(): Long
  fun getUuid(): String

  fun runOnMainThread(block: () -> Unit)
  fun runOnIoThread(block: () -> Unit)

  fun askPermissions(
    onPermissionGranted: (permission: PermissionType) -> Unit,
    onPermissionsDenied: (permission: PermissionType) -> Unit
  )

  fun printThread(desc: String? = null)

  fun getAndroidApplicationContext(): Any
  fun getActivity(): Any

  // "yyyy-MM-dd'T'HH:mm:ss'Z'"
  fun getDiff(startTime: String, endTime: String): String

  // "YYYY-MM-DDThh:mm:ss.sTZD"
  fun getUtcTimeNow(): String

  /**
   * Returns the entire content of the file as a byte array.
   *
   * @param filePath to the File on device
   */
  fun getFileContent(filePath: String): ByteArray

  fun listenForCrashes()

  fun getOsName(): String
  fun getOsVersion(): String
  fun getDeviceInfo(): String

  fun decodeAuthToken(authToken: String): String?

  fun getUrlEncodedString(stringToEncode: String): String
}