package io.dyte.core.models

import io.dyte.core.controllers.GridInfo
import io.dyte.core.controllers.IControllerContainer

/**
 * Dyte room participants
 *
 * @property waitlisted A map that contains all the participants waiting to join the meeting.
 * @property joined A list that contains all the participants who have joined the meeting.
 * @property active A map that contains all the participants except the local user who are supposed to be on the screen at the moment
 * @property pinned A map that contains all the pinned participants of the meeting
 *
 * @constructor Create empty Dyte room participants
 */
data class DyteRoomParticipants(
  val waitlisted: List<DyteMeetingParticipant>,
  val joined: List<DyteMeetingParticipant>,
  val active: List<DyteMeetingParticipant>,
  val screenshares: List<DyteMeetingParticipant>,
  private val controllerContainer: IControllerContainer
) {

  val pinned: DyteMeetingParticipant?
    get() = controllerContainer.participantController.pinnedParticipant

  val gridInfo: GridInfo
    get() = controllerContainer.participantController.gridInfo

  fun toMap() : Map<String, Any?> {
    val map = HashMap<String, Any?>()
    map["waitlisted"] = listDyteMeetingParticipantToMap(waitlisted)
    map["joined"] = listDyteMeetingParticipantToMap(joined)
    map["active"] = listDyteMeetingParticipantToMap(active)
    map["screenshares"] = listDyteMeetingParticipantToMap(screenshares)
    return map
  }

  private fun listDyteMeetingParticipantToMap(participants: List<DyteMeetingParticipant>) : List<Map<String, Any?>> {
    return participants.map { it.toMap() }
  }

  fun setPage(pageNumber: Int) {
    controllerContainer.participantController.setPage(pageNumber)
  }

  @Deprecated("use gridInfo")
  fun getCurrentPageNumber(): Int {
    return controllerContainer.participantController.getCurrentPageNumber()
  }

  @Deprecated("use gridInfo", ReplaceWith("gridInfo.isPreviousPagePossible"))
  fun canGoNextPage(): Boolean {
    return gridInfo.isNextPagePossible
  }

  @Deprecated("use gridInfo", ReplaceWith("gridInfo.isPreviousPagePossible"))
  fun canGoPreviousPage(): Boolean {
    return gridInfo.isPreviousPagePossible
  }

  @Deprecated("use gridInfo", ReplaceWith("gridInfo.shouldShowPaginator"))
  fun shouldShowPaginator(): Boolean {
    return gridInfo.shouldShowPaginator
  }

  @Deprecated("use gridInfo", ReplaceWith("gridInfo.pageCount"))
  fun getPageCount(): Int {
    return gridInfo.pageCount
  }

  fun disableAllAudio() : DyteActionResult {
    // TODO : fix this hardcoding
    return controllerContainer.hostController.muteAllAudio(true)
  }

  fun disableAllVideo() : DyteActionResult {
    return controllerContainer.hostController.muteAllVideo()
  }

  fun acceptAllWaitingRequests() {
    controllerContainer.hostController.acceptAllWaitingRequests()
  }

  /**
   * remove all participants from the meeting
   */
  fun kickAll() : DyteActionResult{
    return controllerContainer.hostController.kickAll()
  }
}