package io.dyte.core.socket.events.payloadmodel.inbound

import io.dyte.core.socket.events.InboundMeetingEventType
import io.dyte.core.socket.events.payloadmodel.BasePayloadModel
import kotlinx.serialization.ExperimentalSerializationApi
import kotlinx.serialization.Serializable
import kotlinx.serialization.json.JsonNames

/**
 * response for event [InboundMeetingEventType.WEB_SOCKET_PEER_JOINED]
 */
@OptIn(ExperimentalSerializationApi::class)
@Serializable
data class WebSocketMeetingPeerUser(
  @JsonNames("id")
  var id: String? = null,

  @JsonNames("userId")
  var userId: String? = null,

  @JsonNames("name", "displayName")
  var name: String? = null,

  @JsonNames("device")
  var device: Device? = null,

  @JsonNames("picture")
  var picture: String? = null,

  @JsonNames("isHost")
  var isHost: Boolean? = null,

  @JsonNames("webinarHiddenParticipant")
  var webinarHiddenParticipant: Boolean? = null,

  @JsonNames("flags")
  var flags: MeetingPeerFlags? = null,

  @JsonNames("clientSpecificId")
  var clientSpecificId: String? = null,

  @JsonNames("audioMuted")
  var audioMuted: Boolean? = null,

  @JsonNames("hiddenParticipant")
  var hiddenParticipant: Boolean? = null
) : BasePayloadModel()

@OptIn(ExperimentalSerializationApi::class)
@Serializable
data class Device(
  @JsonNames("isMobile")
  var isMobile: Boolean? = null,

  @JsonNames("browserName")
  var browserName: String? = null,

  @JsonNames("osName")
  var osName: String? = null,

  @JsonNames("browserVersion")
  var browserVersion: String? = null,

  @JsonNames("osVersionName")
  var osVersionName: String? = null,

  @JsonNames("engineName")
  var engineName: String? = null,
)

@OptIn(ExperimentalSerializationApi::class)
@Serializable
data class MeetingPeerFlags(
  @JsonNames("hiddenParticipant")
  var hiddenParticipant: Boolean? = null,

  @JsonNames("recorder")
  var recordere: Boolean? = null
)

@OptIn(ExperimentalSerializationApi::class)
@Serializable
data class MeetingPeerMetadata(
  @JsonNames("view_type")
  var viewType: String?
)