package io.dyte.core.models

import io.dyte.core.controllers.IControllerContainer
import io.dyte.core.models.WaitListStatus.NONE

// TODO : add enabledPreview, disablePreview
// TODO : getAudioDevices, getVideoDevices, getSpeakerDevices, getDeviceBydId, getAllDevices, setDevice
// TODO : setIsPinned, pin, unpin,
// TODO : add roomJoined, remove userId
// TODO : wrap audioTrack and videoTrack inside preview
// TODO : we can get rid of audioTrack, its not been used anywhere.
class DyteSelfParticipant(
  override val id: String,
  override val userId: String,
  override var name: String,
  override val picture: String?,
  override val isHost: Boolean,
  override val clientSpecificId: String?,
  override val flags: ParticipantFlags,
  controllerContainer: IControllerContainer
) : DyteMeetingParticipant(
  id, userId, name, picture,
  isHost, clientSpecificId, flags, controllerContainer
) {
  val permissions = controllerContainer.presetController.permissions

  val waitListStatus: WaitListStatus
    get() = _waitListStatus

  internal var _waitListStatus: WaitListStatus = NONE

  /**
   * This method is used to unmute the local participant's audio.
   */
  fun enableAudio(): DyteActionResult {
    return controllerContainer.selfController.enableAudio()
  }

  /**
   * This method is used to mute the local participant's audio.
   */
  override fun disableAudio(): DyteActionResult {
    return controllerContainer.selfController.disableAudio()
  }

  /**
   * This method is used to start streaming the local participant's video to the meeting.
   */
  fun enableVideo(): DyteActionResult {
    return controllerContainer.selfController.enableVideo()
  }

  /**
   * This participant is used to disable the local participant's video.
   */
  override fun disableVideo(): DyteActionResult {
    return controllerContainer.selfController.disableVideo()
  }

  fun getEglContext(): Any {
    return controllerContainer.platformUtilsProvider.getPeerConnectionUtils().getEglContext()
  }

  @Suppress("UNUSED_PARAMETER")
  fun setDisplayName(name: String) {
    this.name = name
  }

  fun getAudioDevices(): List<DyteAudioDevice> {
    return controllerContainer.selfController.getAudioDevices()
  }

  fun getVideoDevices(): List<DyteVideoDevice> {
    return controllerContainer.selfController.getVideoDevices()
  }

  fun setDevice(dyteAndroidDevice: DyteAudioDevice) {
    controllerContainer.selfController.setDevice(dyteAndroidDevice)
  }

  fun setVideoDevice(dyteVideoDevice: DyteVideoDevice) {
    controllerContainer.selfController.setDevice(dyteVideoDevice)
  }

  fun getSelectedVideoDevice(): DyteVideoDevice {
    return controllerContainer.selfController.getSelectedVideoDevice()
  }

  fun getSelectedDevice(): DyteAudioDevice {
    return controllerContainer.selfController.getSelectedAudioDevice()
  }

  fun switchCamera(dyteVideoDevice: DyteVideoDevice) {
    controllerContainer.selfController.setDevice(dyteVideoDevice)
  }

  fun canDoParticipantHostControls(): Boolean =
    controllerContainer.presetController.canDoParticipantHostControls()
}