package io.dyte.core.models

import io.dyte.core.controllers.DyteRecordingState
import io.dyte.core.controllers.IControllerContainer
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.runBlocking

/**
 * Dyte recording
 *
 * @property controllerContainer
 * @constructor Create empty Dyte recording
 */
class DyteRecording(private val controllerContainer: IControllerContainer) {
  val recordingState: DyteRecordingState
    get() = controllerContainer.recordingController.getState()

  fun toMap(): Map<String, Any?> {
    val map = HashMap<String, Any?>()
    map["recordingState"] = recordingState
    return map
  }

  /**
   * Starts recording of a given meeting
   */
  fun start(): DyteActionResult {
    return runBlocking(Dispatchers.Default) {
      controllerContainer.recordingController.start()
    }
  }

  /**
   * Stops recording of a given meeting
   */
  fun stop(): DyteActionResult {
    return runBlocking(Dispatchers.Default) {
      controllerContainer.recordingController.stop()
    }
  }
}