package io.dyte.core.controllers

import io.dyte.core.network.info.ParticipantInfo
import io.dyte.core.network.info.ParticipantPermissions

internal class PresetController(
  private val participantInfo: ParticipantInfo,
  controllerContainer: IControllerContainer
) :
  BaseController(controllerContainer), IPresetController {

  override val permissions: ParticipantPermissions
    get() = participantInfo.presetInfo.permissions

  override fun init() {
    // no-op
  }

  override fun canPublishVideo(): Boolean {
    return participantInfo.presetInfo.permissions.mediaPermissions.video.canPublish
  }

  override fun canPublishAudio(): Boolean {
    return participantInfo.presetInfo.permissions.mediaPermissions.canPublishAudio
  }

  override fun canCreatePoll(): Boolean {
    return participantInfo.presetInfo.permissions.pollPermissions.canCreate
  }

  override fun canViewPoll(): Boolean {
    return participantInfo.presetInfo.permissions.pollPermissions.canView
  }

  override fun canVoteOnPoll(): Boolean {
    return participantInfo.presetInfo.permissions.pollPermissions.canVote
  }

  override fun closePlugins(): Boolean {
    return participantInfo.presetInfo.permissions.pluginPermissions.canClose
  }

  override fun canStartPlugins(): Boolean {
    return participantInfo.presetInfo.permissions.pluginPermissions.canStart
  }

  // TODO : fix this
  override fun getMaxVideoCount(): Int {
    return 6
  }

  override fun canRecord(): Boolean {
    return participantInfo.presetInfo.permissions.hostPermissions.canStartRecording
  }

  override fun canSendChatText(): Boolean {
    return participantInfo.presetInfo.permissions.chatPermission.canSend
  }

  override fun canSendChatFile(): Boolean {
    return participantInfo.presetInfo.permissions.chatPermission.canSendFiles
  }

  override fun canDoParticipantHostControls(): Boolean {
    return participantInfo.presetInfo.permissions.hostPermissions.canDisableParticipantAudio
      || participantInfo.presetInfo.permissions.hostPermissions.canDisableParticipantVideo
      || participantInfo.presetInfo.permissions.hostPermissions.canKickParticipant
      || participantInfo.presetInfo.permissions.hostPermissions.canPinParticipant
  }
}

interface IPresetController {
  val permissions: ParticipantPermissions
  fun canPublishVideo(): Boolean
  fun canPublishAudio(): Boolean

  fun canCreatePoll(): Boolean
  fun canViewPoll(): Boolean
  fun canVoteOnPoll(): Boolean

  fun canSendChatText(): Boolean
  fun canSendChatFile(): Boolean

  fun closePlugins(): Boolean
  fun canStartPlugins(): Boolean

  fun getMaxVideoCount(): Int

  fun canRecord(): Boolean

  fun canDoParticipantHostControls(): Boolean
}