package io.dyte.core.controllers

internal class PermissionController(controller: IControllerContainer) : IPermissionController,
  BaseController(controller) {
  override fun init() {
  }

  override val permissions: List<Permission>
    get() = _permissions.toList()

  private val _permissions = arrayListOf<Permission>()

  private var isNotified = false

  override fun isPermissionGrated(permissionType: PermissionType): Boolean {
    return _permissions.find { it.type == permissionType }?.isGranted ?: false
  }

  override fun askPermissions(
    list: List<PermissionType>,
    onPermissionGranted: () -> Unit,
    onPermissionDenied: () -> Unit
  ) {
    _permissions.clear()
    list.forEach {
      _permissions.add(Permission(it, false))
    }

    controllerContainer.platformUtilsProvider.getPlatformUtils()
      .askPermissions(
        { permType ->
          _permissions.find { it.type == permType }?.isGranted = true
          if ( isNotified.not()) {
            onPermissionGranted.invoke()
            isNotified = true
          }
        }, { permType ->
          _permissions.find { it.type == permType }?.isGranted = false
          if ( isNotified.not()) {

            onPermissionDenied.invoke()
            isNotified = true
          }
        })
  }

  override fun arePermissionsGranted() = _permissions.find { it.isGranted.not() } == null
}

interface IPermissionController {
  val permissions: List<Permission>

  fun arePermissionsGranted(): Boolean

  fun isPermissionGrated(permissionType: PermissionType): Boolean

  fun askPermissions(
    list: List<PermissionType>,
    onPermissionGranted: () -> Unit,
    onPermissionDenied: () -> Unit
  )
}

data class Permission(
  val type: PermissionType,
  var isGranted: Boolean
)

enum class PermissionType(val displayName: String) {
  CAMERA("Camera"),
  MICROPHONE("Mic"),
  STORAGE("Storage");
}