package io.dyte.core

import android.content.Context
import android.util.AttributeSet
import android.widget.FrameLayout
import android.widget.LinearLayout
import android.widget.RelativeLayout
import io.dyte.core.controllers.IControllerContainer
import io.dyte.core.models.DyteMeetingParticipant
import org.webrtc.EglBase
import org.webrtc.SurfaceViewRenderer
import org.webrtc.VideoTrack

class VideoView : LinearLayout {
  private var participant: DyteMeetingParticipant? = null
  private var videoRenderer: SurfaceViewRenderer? = null
  private var controllerContainer: IControllerContainer? = null

  constructor(context: Context) : super(context) {
    init(context)
  }

  constructor(context: Context, attrs: AttributeSet?) : super(context, attrs) {
    init(context)
  }

  constructor(context: Context, attrs: AttributeSet?, defStyleAttr: Int) : super(
    context,
    attrs,
    defStyleAttr
  ) {
    init(context)
  }

  private fun init(context: Context) {
    inflate(context, R.layout.view_video, this)
    videoRenderer = findViewById(R.id.video_renderer)
  }

  internal fun setup(controllerContainer: IControllerContainer, dyteParticipant: DyteMeetingParticipant) {
    println("DyteMobileClient | VideoView setup ${dyteParticipant.name}")
    this.participant = dyteParticipant
    this.controllerContainer = controllerContainer
    videoRenderer?.init(controllerContainer.platformUtilsProvider.getPeerConnectionUtils().getEglContext() as EglBase.Context, null)
  }

  fun render() {
    println("DyteMobileClient | VideoView render ${participant?.name}")
    var track: VideoTrack? = null
    if (participant?.screenShareTrack != null && participant?._isScreenshareTrack == true) {
      println("DyteMobileClient | VideoView render screenshare track")
      track = participant?.screenShareTrack as VideoTrack
    }

    if (participant?.videoEnabled == true  && participant?.videoTrack is VideoTrack) {
      println("DyteMobileClient | VideoView render video track")
      track = participant?.videoTrack as VideoTrack
    }

    if (track != null) {
      videoRenderer?.visibility = VISIBLE
      track.removeSink(videoRenderer)
      track.addSink(videoRenderer)
    } else {
      videoRenderer?.visibility = GONE
    }
  }

  fun release() {
    videoRenderer?.clearImage()
    videoRenderer?.release()
  }
}