package io.dyte.core.platform

import io.dyte.core.models.AudioDeviceType
import io.dyte.core.models.DyteAudioDevice
import io.dyte.core.models.DyteVideoDevice

/**
 * I dyte media utils
 *
 * Needs to be implemented by each platform.
 *
 * @constructor Create empty I dyte media utils
 */
interface IDyteMediaUtils {
  fun init()

  fun getAudioDevices(): List<DyteAudioDevice>
  fun setAudioDevice(device: DyteAudioDevice)
  fun getSelectedAudioDevice(): DyteAudioDevice

  fun getVideoDevices(): List<DyteVideoDevice>
  fun setVideoDevice(device: DyteVideoDevice)
  fun getSelectedVideoDevice(): DyteVideoDevice
}