package io.dyte.core.listeners

import io.dyte.core.controllers.DyteRecordingState
import io.dyte.core.models.DyteChatMessage
import io.dyte.core.models.DytePollMessage

/**
 * Dyte meeting room events listener
 *
 * You can subscribe to all room events by implementing this interface.
 * To subscribe pass implementation to [io.dyte.core.DyteMobileClient.addMeetingRoomEventsListener]
 */
interface DyteMeetingRoomEventsListener {
  fun onMeetingInitStarted() {}
  fun onMeetingInitCompleted() {}
  fun onMeetingInitFailed(exception: Exception) {}

  fun onWaitingRoomEntered() {}
  fun onWaitingRoomEntryAccepted() {}
  fun onWaitingRoomEntryRejected() {}

  /**
   * On chat updates
   *
   * Triggered when there is a new chat message available in this room.
   *
   * @param newMessage true, if a new message is received else false
   * @param message new message
   * @param messages list of all messages in this room. This also contains messages exchanged before this peer joined in this room
   */
  fun onChatUpdates(
    newMessage: Boolean,
    message: DyteChatMessage?,
    messages: List<DyteChatMessage>
  ) {
  }

  /**
   * On poll updates
   *
   * Triggered when there is a new poll available in this room or if there is any update on existing poll.
   * Update on poll can happen once user votes on any given poll.
   *
   * @param newPoll true, if a new poll is received else false
   * @param pollMessages list of all polls in this room. This also contains polls exchanged before this peer joined in this room
   * @param updatedPollMessage poll which got updated.
   */
  fun onPollUpdates(newPoll: Boolean, pollMessages: List<DytePollMessage>, updatedPollMessage: DytePollMessage?) {}

  /**
   * On meeting recording started
   *
   * Triggered when someone starts recording this room
   *
   */
  fun onMeetingRecordingStarted() {}

  /**
   * On meeting recording ended
   *
   * Triggered when someone stops recording this room
   *
   */
  fun onMeetingRecordingEnded() {}

  fun onMeetingRecordingStopError(e:Exception) {}

  fun onMeetingRecordingStateUpdated(state: DyteRecordingState) {}

  /**
   * triggered when host kick this participant or kick all.
   */
  fun onHostKicked() {}
}