package io.dyte.core.platform

import android.content.Context
import io.dyte.core.VideoView
import io.dyte.core.models.DyteMeetingParticipant

actual typealias VideoView = VideoView

class DyteAndroidVideoUtils(private val utilsProvider: IDytePlatformUtilsProvider) :
  IDyteVideoUtils {
  private val videoViews = hashMapOf<String, VideoView>()

  override fun getVideoView(participant: DyteMeetingParticipant): VideoView {
    return if (videoViews.containsKey(participant.id)) {
      videoViews.getValue(participant.id)
    } else {
      val videoView = VideoView(
        utilsProvider.getControllerContainer().platformUtilsProvider.getPlatformUtils()
          .getActivity() as Context
      )
      videoView.setup(utilsProvider.getControllerContainer(), participant)
      videoViews[participant.id] = videoView
      videoView
    }
  }

  override fun destroyView(participant: DyteMeetingParticipant) {
    videoViews.remove(participant.id)
  }
}