package io.dyte.core.socket.events.payloadmodel.inbound

import io.dyte.core.socket.events.InboundMeetingEventType
import io.dyte.core.socket.events.payloadmodel.BasePayloadModel
import io.dyte.core.socket.events.payloadmodel.outbound.Codec
import io.dyte.core.socket.events.payloadmodel.outbound.HeaderExtension
import kotlinx.serialization.ExperimentalSerializationApi
import kotlinx.serialization.Serializable
import kotlinx.serialization.json.JsonNames

/**
 * response for event [InboundMeetingEventType.WEB_SOCKET_NEW_CONSUMER]
 */
@OptIn(ExperimentalSerializationApi::class)
@Serializable
data class WebSocketConsumerModel(
  @JsonNames("peerId")
  var peerId: String? = null,

  @JsonNames("producerId")
  var producerId: String? = null,

  @JsonNames("id")
  var id: String? = null,

  @JsonNames("kind")
  var kind: String? = null,

  @JsonNames("rtpParameters")
  var rtpParameters: ConsumerRtpParameters? = null,

  @JsonNames("type")
  var type: String? = null,

  @JsonNames("appData")
  var appData: ConsumerAppData? = null,

  @JsonNames("remotelyPaused")
  val remotelyPaused: Boolean? = null,

  @JsonNames("producerPaused")
  val producerPaused: Boolean? = null
) : BasePayloadModel()

@OptIn(ExperimentalSerializationApi::class)
@Serializable
data class ConsumerRtpParameters(
  @JsonNames("codecs")
  val codecs: List<Codec>? = null,

  @JsonNames("headerExtensions")
  val headerExtensions: List<HeaderExtension>? = null,

  @JsonNames("encodings")
  val encodings: List<Encodings>? = null,

  @JsonNames("rtcp")
  val rtcp: Rtcp? = null,

  @JsonNames("mid")
  val mid: String? = null
)

@OptIn(ExperimentalSerializationApi::class)
@Serializable
data class ConsumerAppData(
  @JsonNames("screenShare")
  val screenShare: Boolean? = false,

  @JsonNames("peerId")
  val peerId: String
)

@OptIn(ExperimentalSerializationApi::class)
@Serializable
data class Encodings(
  @JsonNames("ssrc")
  val ssrc: Int? = null,

  @JsonNames("rtx")
  val rtx: Rtx? = null,

  @JsonNames("scalabilityMode")
  val scalabilityMode: String? = null
)

@OptIn(ExperimentalSerializationApi::class)
@Serializable
class Rtx(
  @JsonNames("ssrc")
  val ssrc: Int? = null
)

@OptIn(ExperimentalSerializationApi::class)
@Serializable
data class Rtcp(
  @JsonNames("cname")
  val cname: String? = null,

  @JsonNames("reducedSize")
  val reducedSize: Boolean? = null,

  @JsonNames("mux")
  val mux: Boolean? = null
) 