package io.dyte.core.platform

import com.dyte.mobilecorekmm.platform.IDyteMediaSoupClientCallback
import io.dyte.core.controllers.IControllerContainer

/**
 * I dependency provider
 *
 * needs to be implemented by android & iOS separately.
 *
 * @constructor Create empty I dependency provider
 */
interface IDytePlatformUtilsProvider {
  fun init(controllerContainer: IControllerContainer, mediaSoupClientCallback: IDyteMediaSoupClientCallback)
  fun getPlatformUtils(): IDytePlatformUtils
  fun getLogger(): IDyteLoggerUtils
  fun getMediaUtils(): IDyteMediaUtils
  fun getPeerConnectionUtils(): IDytePeerConnectionUtils
  fun getMediaSoupUtils(): IDyteMediaSoupUtils
  fun getControllerContainer(): IControllerContainer
  fun createWebView(): IDyteWebView
}