package io.dyte.core.platform

interface IDytePeerConnectionUtils {
  /**
   * Switch camera
   *
   * toggles between front camera and back camera
   */
  fun switchCamera()

  /**
   * Create audio track
   *
   * @return instance of AudioTrack from org.webrtc
   */
  fun createAudioTrack(id: String): Any

  /**
   * Create video track
   *
   * @return instance of videoTrack from org.webrtc
   */
  fun createVideoTrack(id: String): Any

  fun stopVideo()
  fun resumeVideo()

  fun getEglContext(): Any

  fun dispose()

  fun onCameraClosed()
}