package io.dyte.core.network.models

import kotlinx.coroutines.DelicateCoroutinesApi
import kotlinx.serialization.ExperimentalSerializationApi
import kotlinx.serialization.Serializable
import kotlinx.serialization.json.JsonNames

@OptIn(ExperimentalSerializationApi::class, DelicateCoroutinesApi::class)
@Serializable
data class MeetingSessionData(
  @JsonNames("title")
  val title: String? = null,

  @JsonNames("roomNodeLink")
  val roomNodeLink: String? = null,

  @JsonNames("roomName")
  val roomName: String? = null,

  @JsonNames("password")
  val password: String? = null
)

@OptIn(ExperimentalSerializationApi::class, DelicateCoroutinesApi::class)
@Serializable
data class MeetingSessionDataWrapper(
  @JsonNames("data")
  val data: MeetingSessionWrapper
)

@OptIn(ExperimentalSerializationApi::class, DelicateCoroutinesApi::class)
@Serializable
data class MeetingSessionWrapper(
  @JsonNames("session")
  val session: MeetingSessionData
)
