package io.dyte.core.models

import io.dyte.core.controllers.IControllerContainer
import io.dyte.core.controllers.PermissionType.CAMERA

// TODO : add enabledPreview, disablePreview
// TODO : getAudioDevices, getVideoDevices, getSpeakerDevices, getDeviceBydId, getAllDevices, setDevice
// TODO : setIsPinned, pin, unpin,
// TODO : add roomJoined, remove userId
// TODO : wrap audioTrack and videoTrack inside preview
// TODO : we can get rid of audioTrack, its not been used anywhere.
class DyteSelfParticipant(
  override val id: String,
  override val userId: String,
  override var name: String,
  override val picture: String?,
  override val isHost: Boolean,
  override val clientSpecificId: String?,
  override val flags: ParticipantFlags,
  override var audioEnabled: Boolean,
  override var videoEnabled: Boolean,
  controllerContainer: IControllerContainer
) : DyteMeetingParticipant(
  id, userId, name, picture,
  isHost, clientSpecificId, flags, audioEnabled,
  videoEnabled, controllerContainer
) {
  val permission = controllerContainer.presetController.permission
  /**
   * This method is used to unmute the local participant's audio.
   */
  @Throws(UnsupportedOperationException::class)
  fun enableAudio() {
    controllerContainer.selfController.enableAudio()
  }

  /**
   * This method is used to mute the local participant's audio.
   */
  override fun disableAudio() {
    controllerContainer.selfController.disableAudio()
  }

  /**
   * This method is used to start streaming the local participant's video to the meeting.
   */
  @Throws(UnsupportedOperationException::class)
  fun enableVideo() {
    controllerContainer.selfController.enableVideo()
  }

  /**
   * This participant is used to disable the local participant's video.
   */
  override fun disableVideo() {
    controllerContainer.selfController.disableVideo()
  }

  @Throws(UnsupportedOperationException::class)
  fun getSelfPreviewTrack(): Any? {
    if(!controllerContainer.permissionController.isPermissionGrated(CAMERA)) {
      return null
    }
    return controllerContainer.platformUtilsProvider.getPeerConnectionUtils()
      .createVideoTrack("cam")
  }

  fun getEglContext(): Any {
    return controllerContainer.platformUtilsProvider.getPeerConnectionUtils().getEglContext()
  }

  @Suppress("UNUSED_PARAMETER")
  fun setDisplayName(name: String) {
    this.name = name
  }

  fun getAudioDevices(): List<DyteAudioDevice> {
    return controllerContainer.selfController.getAudioDevices()
  }

  fun getVideoDevices(): List<DyteVideoDevice> {
    return controllerContainer.selfController.getVideoDevices()
  }

  fun setDevice(dyteAndroidDevice: DyteAudioDevice) {
    controllerContainer.selfController.setDevice(dyteAndroidDevice)
  }

  fun setVideoDevice(dyteVideoDevice: DyteVideoDevice) {
    controllerContainer.selfController.setDevice(dyteVideoDevice)
  }

  fun getSelectedVideoDevice(): DyteVideoDevice {
    return controllerContainer.selfController.getSelectedVideoDevice()
  }

  fun getSelectedDevice(): DyteAudioDevice {
    return controllerContainer.selfController.getSelectedAudioDevice()
  }

  fun switchCamera(dyteVideoDevice: DyteVideoDevice) {
    controllerContainer.selfController.setDevice(dyteVideoDevice)
  }
}