package io.dyte.core.models

import io.dyte.core.controllers.IControllerContainer
import io.dyte.core.controllers.PageViewMode

// TODO: setPage, setViewMode,
// TODO: do not add self in joined
// TODO: add count, pageCount, maxActiveParticipantsCount
// TODO: @see disableAllAudio()
/**
 * Dyte room participants
 *
 * @property waitlisted A map that contains all the participants waiting to join the meeting.
 * @property joined A list that contains all the participants who have joined the meeting.
 * @property active A map that contains all the participants except the local user who are supposed to be on the screen at the moment
 * @property pinned A map that contains all the pinned participants of the meeting
 *
 * @constructor Create empty Dyte room participants
 */
data class DyteRoomParticipants(
  val waitlisted: List<DyteMeetingParticipant>,
  val joined: List<DyteMeetingParticipant>,
  val active: List<DyteMeetingParticipant>,
  val screenshares: List<DyteMeetingParticipant>,
  private val controllerContainer: IControllerContainer
) {
  fun setMode(viewMode: PageViewMode) {
    controllerContainer.participantController.setViewMode(viewMode)
  }

  fun toMap() : Map<String, Any?> {
    val map = HashMap<String, Any?>()
    map["waitlisted"] = listDyteMeetingParticipantToMap(waitlisted)
    map["joined"] = listDyteMeetingParticipantToMap(joined)
    map["active"] = listDyteMeetingParticipantToMap(active)
    map["screenshares"] = listDyteMeetingParticipantToMap(screenshares)
    return map
  }

  private fun listDyteMeetingParticipantToMap(participants: List<DyteMeetingParticipant>) : List<Map<String, Any?>> {
    return participants.map { it.toMap() }
  }

  fun setPage(pageNumber: Int) {
    controllerContainer.participantController.setPage(pageNumber)
  }

  @Throws(UnsupportedOperationException::class)
  fun disableAllAudio() {
    // TODO : fix this hardcoding
    controllerContainer.hostController.muteAllAudio(true)
  }

  @Throws(UnsupportedOperationException::class)
  fun disableAllVideo() {
    controllerContainer.hostController.muteAllVideo()
  }

  /**
   * remove all participants from the meeting
   */
  @Throws(UnsupportedOperationException::class)
  fun kickAll() {
    controllerContainer.hostController.kickAll()
  }
}