package io.dyte.core.models

import io.dyte.core.controllers.IControllerContainer
import io.dyte.core.socket.events.payloadmodel.inbound.WebSocketPoll

/**
 * Dyte poll
 *
 * @property controllerContainer
 * @constructor Create empty Dyte poll
 */
class DytePoll(private val controllerContainer: IControllerContainer) {

  val items : List<DytePollMessage>
   get() = controllerContainer.pollsController.polls

  fun toMap() : List<Map<String, Any?>> {
    return items.map { it.toMap() }
  }

  /**
   * Vote on poll
   *
   * @param pollMessage
   * @param pollOption
   */
  @Throws(UnsupportedOperationException::class)
  fun vote(pollMessage: DytePollMessage, pollOption: DytePollOption) {
    controllerContainer.pollsController.vote(pollMessage, pollOption)
  }

  /**
   * Create poll
   *
   * @param question
   * @param options
   * @param anonymous
   * @param hideVotes
   */
  @Throws(UnsupportedOperationException::class)
  fun create(question: String, options: List<String>, anonymous: Boolean, hideVotes: Boolean) {
    controllerContainer.pollsController.create(question, options, anonymous, hideVotes)
  }
}