package io.dyte.core.models

import io.dyte.core.controllers.IControllerContainer

/**
 * Dyte Plugins
 *
 * @property controllerContainer
 * @constructor Create un-activated Dyte Plugin
 */
class DytePlugins(private val controllerContainer: IControllerContainer) {
    val all: List<DytePlugin>
        get() = controllerContainer.pluginsController.plugins
    val active: List<DytePlugin>
        get() = controllerContainer.pluginsController.plugins.filter { it.isActive }
}